<?php
    /*
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    
    $parametri = array("tabella"=>"geec_utenzeApi", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>array("nomeUtenza"=>$cerca),"ajax"=>false);
      
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"impostazioni.php");
?>
    <h4 class="mb-4 title">API</h4>
    <hr> 

    <div class="row">
        <div class="col-lg-4 col-xl-3 sticky-top align-self-start">
            <form>
                <div class="mb-4 add-box">
                    <h6 class="mb-3"> Crea nuova utenza</h6>
                    <div class="options-box">

                        <div class="form-group">
                            <label for="nome-voce-menu-1">Nome</label>
                            <input type="text" class="form-control" id="nomeUtenza" placeholder="Nome utenza">
                        </div>
                        
                        <div class="form-group">
                            <label for="nome-voce-menu-1">Codice segreto</label>
                            <input type="text" class="form-control" id="codiceSegretoUtenza" placeholder="Codice segreto">
                        </div>
                        
                        <button type="button" class="btn btn-primary float-right" value="Aggiungi"  onclick="aggiungiUtenzaApi('../')"><i class="fas fa-plus mr-2"></i>Crea</button>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-lg-8 col-xl-9 mb-4 gerarchia-menu">
            <div class="d-flex justify-content-between mb-3">
                <?php
                    $ricerca->stampaSelectNumeroElementi($cerca);
                    $ricerca->stampaFormRicerca($cerca);
                ?>
            </div>
            <div class="table-responsive" id="divElencoUtenzeApi">
                <?php
                    if(isset($_GET["pag"])) {
                        $ris = $ricerca->eseguiRicerca($_GET["pag"],"OR");
                    }
                    else {
                        $ris = $ricerca->eseguiRicerca(1,"OR");
                    }

                    $colonne = array("ID","Utenza","Attiva","Codice segreto","Permessi","");
                    $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                    $tabella->setTipo("normale");
                    while($utenzaApi = $ris->fetch_assoc()) {
                        $nomeEscape = filter_var($utenzaApi["nomeUtenza"],FILTER_SANITIZE_ADD_SLASHES);
                        
                        $stringaPermessi ="";
                        if($utenzaApi["permessiLettura"]=="si") {
                            $stringaPermessi = "lettura";
                        }
                        $stringaPermessi .= " - ";
                        if($utenzaApi["permessiScrittura"]=="si") {
                            $stringaPermessi .= "scrittura";
                        }

                        $azioni = array("modifica"=>"javascript:void\" onclick=\"modificaUtenzaApi({$utenzaApi["id"]},'$nomeEscape','{$utenzaApi["codiceSegreto"]}','{$utenzaApi["attiva"]}','{$utenzaApi["permessiLettura"]}','{$utenzaApi["permessiScrittura"]}')","elimina"=>"apriPopupEliminaUtenzaApi({$utenzaApi["id"]},'{$nomeEscape}')");
                        $tabella->aggiungiNuovaRiga(array($utenzaApi["id"],"<a href=\"javascript:void\" onclick=\"modificaUtenzaApi({$utenzaApi["id"]},'$nomeEscape','{$utenzaApi["codiceSegreto"]}','{$utenzaApi["attiva"]}','{$utenzaApi["permessiLettura"]}','{$utenzaApi["permessiScrittura"]}')\"><b>{$utenzaApi["nomeUtenza"]}</b></a>",$utenzaApi["attiva"],$utenzaApi["codiceSegreto"],$stringaPermessi), $azioni);
                    }
                    $tabella->stampa("utenzaApi",0);
                    $ricerca->stampaPaginazione(true,"impsotazioni.php");
                ?>
            </div>
        </div>
    </div>
    